/* 5272 Unity System
Scott Mauer
Metrowersks 2001

This file provides a linkage between the Motorola low-level
initialization and byte-out/byte-in routines and their 
Metrowerks analogs.
*/
#include "metrowerks_UART.h"
#include <stdio.h>
/****************************************************************************/

UARTError InitializeUART(UARTBaudRate baudRate)
{
//	SerialInit( baudRate );

	return kUARTNoError;
}

/****************************************************************************/
/*
	ReadUARTN
	
	Read N bytes from the UART.
	
	bytes			pointer to result buffer
	limit			size of buffer and # of bytes to read
*/
/****************************************************************************/
UARTError ReadUARTN(void* bytes, unsigned long limit)
{
	int count;
	UARTError err; 

	for (count = 0, err = kUARTNoError; 
		count < limit && err == kUARTNoError;
		count++)
        {
//		err = ReadUART1( (char *)bytes + count );
        *( (char *)bytes + count )=in_char();
        }

	return err;
}

/****************************************************************************/

UARTError WriteUARTN(const void* bytes, unsigned long length)
{
	int count;
	UARTError err;

	for (count = 0, err = kUARTNoError;
		count < length && err == kUARTNoError;
		count++)
        {
//		err = WriteUART1( ((char *)bytes)[ count ] );
        out_char(*( ((char *)bytes) + count));
        } 

	return err;
}

